//
//  Chap7.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/03/30.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap7_h
#define Chap7_h
/*-------------------------------------------------*/
/*［７］Hayter分布，Lee-Spurrier分布，Williams分布　　  */
/*-------------------------------------------------*/
// 原始関数の有限sinc補間
double FInterpolation(double t,int n,double t0,double h,double sg,double *g){
    /*D1CDF,D2CDF,D3CDFのsinc補間関数F_n(t)≅F(t)の計算*/
    /*近似台半幅分割数n，標本点原点t0，標本点間隔h，標準偏差sg，補間係数g[2n+1]*/
    int i;
    double Fn,ts[300];
    for(i=-n;i<=n;i++)ts[i+n]=t0+i*h;//標本点の生成
    Fn=PhiCDF(sg,t-t0);//正規分布の分布関数の項
    for(i=0;i<=2*n;i++)Fn+=g[i]*snc(h,ts[i],t);//sinc補間項を加算
    return Fn;
};

//漸近分布
double D1CDF(double t,int k){/*Hayter分布の漸近分布*/
#include "HayterData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double D2CDF(double t,int k){/*Lee-Spurrier分布の漸近分布*/
#include "LeeSpurrierData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double D3CDF(double t,int k){/*Williams分布の漸近分布*/
#include "WilliamsData.dat"
    int n,id;
    double t0,h,sg;
    if(k<2||k>20)return NAN;
    if(t<0)return 0;
    if(k==2)return PhiCDF(1,t);
    n=ns[k];t0=t0s[k];h=hs[k];sg=sgs[k];id=ids[k];
    return FInterpolation(t,n,t0,h,sg,&gs[id]);
};
double TD1CDF(double t,int k,int m){/*Hayter分布の漸近分布*/
    if(m==-1) return D1CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D1CDF,t,k,m);
};
double TD2CDF(double t,int k,int m){/*Lee-Spurrier分布*/
    if(m==-1) return D2CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D2CDF,t,k,m);
};
double TD3CDF(double t,int k,int m){/*Williams分布*/
    if(m==-1) return D3CDF(t,k);
    if(k<2||k>20||m<2)return NAN;
    return chiIntegralHayter(D3CDF,t,k,m);
};

//100α%点
double td1Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD1CDF,k,m,al);
};
double td2Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD2CDF,k,m,al);
};
double td3Fun(int k,int m,double al){
    double eps=1.0e-8;
    if(k<2||k>20||(m<2&&m!=-1)||al<eps||al>0.5)return NAN;
    return SecantHayter(TD3CDF,k,m,al);
};
double d1Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD1CDF,k,-1,al);
};
double d2Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD2CDF,k,-1,al);
};
double d3Fun(int k,double al){
    double eps=1.0e-8;
    if(k<2||k>20||al<eps||al>0.5)return NAN;
    return SecantHayter(TD3CDF,k,-1,al);
};

//表関数(T1型）
double** td1Tab(int k,int m,double al){/*Hayter td1Fun(k,m,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(td1Fun,k,m,al);
};
double** td2Tab(int k,int m,double al){/*Lee-Spurrier td2Fun(k,m,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(td2Fun,k,m,al);
};
double* td3Tab(int k,int m,double al){/*Williams td3Fun(k,m,al)のT3型1次元表配列の出力 */
    return MakeTabT3td(td3Fun,k,m,al);
};
double** d1Tab(int k,double al){/*Hayter d1Fun(k,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(td1Fun,k,-1,al);
};
double** d2Tab(int k,double al){/*Lee-Spurrier d2Fun(k,al)のT1型2次元表配列の出力 */
    return MakeTabT1td(td2Fun,k,-1,al);
};
double* d3Tab(int k,double al){/*Williams d3Fun(k,al)のT3型1次元表配列の出力 */
    return MakeTabT3td(td3Fun,k,-1,al);
};

#endif /* Chap7_h */
